/////////////////////////////////////////////////////////////
// CINEMA SDK : MESSAGES																	 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_CUSTOMGUIDATA_H
#define __C4D_CUSTOMGUIDATA_H

#include "c4d_basedata.h"

class String;
class BaseContainer;
class BaseDocument;
class BaseBitmap;
struct CUSTOMGUIPLUGIN;

class CDialog;

// 'info' for CustomGui registration
#define CUSTOMGUI_SUPPORT_LAYOUTSWITCH		1

#define CUSTOMGUIARRAY_SIZE(A) (sizeof(A) / sizeof(A[0]))

enum CUSTOMTYPE
{
	CUSTOMTYPE_END,
	CUSTOMTYPE_FLAG,
	CUSTOMTYPE_LONG,
	CUSTOMTYPE_REAL,
	CUSTOMTYPE_STRING,
	CUSTOMTYPE_VECTOR
};

struct CustomProperty
{
	CUSTOMTYPE	type;
	LONG				id;
	CHAR				*ident;
};

class CustomGuiData : public BaseData
{
	public:
		virtual LONG								GetId() = NULL;
		virtual CDialog*						Alloc(const BaseContainer &settings) = NULL;
		virtual void								Free(CDialog *dlg,void *userdata) = NULL;
		virtual CHAR*								GetResourceSym() = NULL;
		virtual CustomProperty*			GetProperties();
		virtual LONG								GetResourceDataType(LONG *&table);

		CUSTOMGUIPLUGIN*						GetPlugin();
};

Bool RegisterCustomGuiPlugin(const String &str, LONG info, CustomGuiData *dat);

#endif
